﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CashierCrisis.Behaviors
{
    public delegate bool EvaluateDelegate();

    public class Condition : Action
    {
        public EvaluateDelegate Evaluation { get; set; }
        public bool IsContinuous { get; set; }

        public override Status Execute(Microsoft.Xna.Framework.GameTime gameTime)
        {

            bool eval = Evaluate();

            if (eval)
            {
                if (!IsContinuous)
                {
                    return Completed;
                }

                return Running;
            }

            return Failed;
        }

        public virtual bool Evaluate()
        {
            return Evaluation();
        }
    }
}
